-- Adminer 4.7.6 MySQL dump
DROP TABLE IF EXISTS `temp_broadcastercodes`;
CREATE TABLE `temp_broadcastercodes`
(
    `id`             int(11) NOT NULL AUTO_INCREMENT,
    `broadcaster_id` int(11) NOT NULL,
    `code`           varchar(255)       DEFAULT NULL,
    `created_at`     timestamp NOT NULL DEFAULT current_timestamp(),
    `updated_at`     timestamp NOT NULL DEFAULT current_timestamp(),
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `temp_broadcasters`;
CREATE TABLE `temp_broadcasters`
(
    `id`                     int(11) NOT NULL AUTO_INCREMENT,
    `name`                   varchar(255) NOT NULL,
    `email`                  varchar(255) NOT NULL,
    `password`               varchar(255) NOT NULL,
    `remember_token`         varchar(255)          DEFAULT NULL,
    `B_type`                 int(11) NOT NULL,
    `channel_name`           varchar(255) NOT NULL,
    `http_port`              int(11) DEFAULT NULL,
    `rtmp_port`              int(11) DEFAULT NULL,
    `domain`                 varchar(255)          DEFAULT NULL,
    `ftp`                    varchar(255)          DEFAULT NULL,
    `rtmp_auth`              varchar(255)          DEFAULT NULL,
    `logo_wm`                varchar(255)          DEFAULT NULL,
    `logowm_status`          int(11) NOT NULL DEFAULT 0,
    `status`                 int(11) NOT NULL DEFAULT 1,
    `start_stop`             int(11) NOT NULL DEFAULT 1,
    `start_stop_webtv`       int(11) NOT NULL DEFAULT 1,
    `viewers_limit`          int(11) NOT NULL,
    `bitrate`                int(11) NOT NULL,
    `m_bitrate`              int(11) NOT NULL,
    `fb_stream`              int(11) NOT NULL DEFAULT 0,
    `youtube_stream`         int(11) NOT NULL DEFAULT 0,
    `twitch_stream`          int(11) NOT NULL DEFAULT 0,
    `pscp_stream`            int(11) NOT NULL DEFAULT 0,
    `dmotion_stream`         int(11) NOT NULL DEFAULT 0,
    `custom_stream`          int(11) NOT NULL DEFAULT 0,
    `telegram_stream`        int(11) NOT NULL DEFAULT 0,
    `wm_brandlogo`           int(11) NOT NULL DEFAULT 1,
    `vdo_directory`          int(11) NOT NULL DEFAULT 0,
    `station_storage`        int(11) NOT NULL,
    `traffic_month`          int(11) NOT NULL,
    `traffic_hold`           int(11) NOT NULL DEFAULT 0,
    `playerpic`              varchar(255) NOT NULL DEFAULT 'background-1.jpg',
    `player_fail_pic`        varchar(255) NOT NULL DEFAULT 'player-fail-pic-1.gif',
    `player_fail_pic_status` int(11) NOT NULL DEFAULT '0',
    `chat`                   int(11) NOT NULL DEFAULT 0,
    `chat_msg`               int(11) NOT NULL DEFAULT 100,
    `wm_position`            varchar(255) NOT NULL DEFAULT 'topright',
    `wm_size`                int(11) NOT NULL DEFAULT 0,
    `wm_hor_vert_pos`        varchar(255) NOT NULL DEFAULT '0,0,0,0',
    `wm_opacity`             int(11) NOT NULL DEFAULT 100,
    `ip_lock`                int(11) NOT NULL DEFAULT 0,
    `iplock_type`            int(11) NOT NULL DEFAULT 1,
    `loadb`                  int(11) NOT NULL DEFAULT 0,
    `stream_type_admin`      int(11) NOT NULL DEFAULT 0,
    `stream_type`            varchar(250) NOT NULL DEFAULT 'single',
    `stream_multi`           varchar(250) NOT NULL DEFAULT '0',
    `restream_record`        int(11) NOT NULL DEFAULT 0,
    `autoplay`               int(1) NOT NULL DEFAULT 0,
    `viewers`                int(11) NOT NULL DEFAULT 0,
    `widget_viewers`         int(11) NOT NULL DEFAULT 1,
    `pictureInPicture`       enum('true','false') NOT NULL DEFAULT 'false',
    `vast_google_ads`        int(11) NOT NULL DEFAULT '0',
    `vast_google_ads_url`    text                  DEFAULT NULL,
    `proxy_status`           int(11) NOT NULL DEFAULT 0,
    `geoblock`               int(11) NOT NULL DEFAULT '0',
    `geoblock_type`          int(11) NOT NULL DEFAULT '1',
    `geoblock_cntry`         varchar(800) NOT NULL DEFAULT '_NONE_',
    `scrolltext_status`      int(11) NOT NULL DEFAULT '0',
    `scrolltext_txt`         longtext,
    `scrolltext_font`        varchar(255) NOT NULL DEFAULT 'DejaVuSans.ttf',
    `scrolltext_position1`   varchar(255) NOT NULL DEFAULT 'bottom',
    `scrolltext_position2`   int(11) NOT NULL DEFAULT '10',
    `scrolltext_speed`       int(11) NOT NULL DEFAULT '60',
    `scrolltext_direction`   varchar(255) NOT NULL DEFAULT 'right',
    `scrolltext_fcolor`      varchar(255) NOT NULL DEFAULT '#ffffff',
    `scrolltext_fsize`       int(11) NOT NULL DEFAULT '22',
    `scrolltext_brw`         int(11) NOT NULL DEFAULT '0',
    `scrolltext_bcolor`      varchar(255) NOT NULL DEFAULT '#f5692c',
    `ytcookies`              int(11) NOT NULL DEFAULT '0',
    `timezone`               varchar(255) NOT NULL DEFAULT 'UTC',
    `lang`                   varchar(50)  NOT NULL DEFAULT 'English - English',
    `created_at`             timestamp    NOT NULL DEFAULT current_timestamp(),
    `updated_at`             timestamp    NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp (),
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `temp_files`;
CREATE TABLE `temp_files`
(
    `id`             int(11) NOT NULL AUTO_INCREMENT,
    `broadcaster_id` int(11) NOT NULL,
    `file`           varchar(255) NOT NULL,
    `created_at`     timestamp    NOT NULL DEFAULT current_timestamp(),
    `updated_at`     timestamp    NOT NULL DEFAULT current_timestamp(),
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `temp_file_managers`;
CREATE TABLE `temp_file_managers`
(
    `id`             int(11) NOT NULL AUTO_INCREMENT,
    `broadcaster_id` int(11) NOT NULL,
    `parent_id`      int(11) NOT NULL,
    `name`           varchar(255) NOT NULL,
    `created_at`     timestamp    NOT NULL DEFAULT current_timestamp(),
    `updated_at`     timestamp    NOT NULL DEFAULT current_timestamp(),
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `temp_live_settings`;
CREATE TABLE `temp_live_settings`
(
    `id`             int(11) NOT NULL AUTO_INCREMENT,
    `broadcaster_id` int(11) NOT NULL,
    `ip`             varchar(255) NOT NULL DEFAULT 'no-ip',
    `bitrate`        varchar(255) NOT NULL,
    `created_at`     timestamp    NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp (),
    `updated_at`     timestamp    NOT NULL DEFAULT current_timestamp(),
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `temp_logincodes`;
CREATE TABLE `temp_logincodes`
(
    `id`             int(11) NOT NULL AUTO_INCREMENT,
    `broadcaster_id` int(11) NOT NULL,
    `code`           varchar(255) NOT NULL,
    `created_at`     timestamp    NOT NULL DEFAULT current_timestamp(),
    `updated_at`     timestamp    NOT NULL DEFAULT current_timestamp(),
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `temp_playlists`;
CREATE TABLE `temp_playlists`
(
    `id`             int(11) NOT NULL AUTO_INCREMENT,
    `broadcaster_id` int(11) DEFAULT NULL,
    `title`          varchar(255) NOT NULL,
    `Mode`           varchar(255) NOT NULL,
    `status`         varchar(255) NOT NULL,
    `tags`           text,
    `durations`      varchar(255)          DEFAULT NULL,
    `vod`            int(11) NOT NULL DEFAULT '0',
    `created_at`     timestamp    NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp (),
    `updated_at`     timestamp    NOT NULL DEFAULT current_timestamp(),
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `temp_reseller_broadcasters`;
CREATE TABLE `temp_reseller_broadcasters`
(
    `id`             int(11) NOT NULL AUTO_INCREMENT,
    `reseller_id`    int(11) NOT NULL,
    `broadcaster_id` int(11) NOT NULL,
    `created_at`     timestamp NOT NULL DEFAULT current_timestamp(),
    `updated_at`     timestamp NOT NULL DEFAULT current_timestamp(),
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `temp_schedulers`;
CREATE TABLE `temp_schedulers`
(
    `id`             int(11) NOT NULL AUTO_INCREMENT,
    `playlist_id`    int(11) DEFAULT NULL,
    `broadcaster_id` int(11) NOT NULL,
    `scheduler_type` varchar(255) NOT NULL,
    `link`           varchar(255)          DEFAULT NULL,
    `name`           varchar(255)          DEFAULT NULL,
    `status`         varchar(255) NOT NULL DEFAULT 'off',
    `days`           varchar(255)          DEFAULT NULL,
    `start_day`      date                  DEFAULT NULL,
    `end_day`        date                  DEFAULT NULL,
    `start_hour`     time                  DEFAULT NULL,
    `end_hour`       time                  DEFAULT NULL,
    `run`            int          NOT NULL DEFAULT '1',
    `created_at`     timestamp    NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp (),
    `updated_at`     timestamp    NOT NULL DEFAULT current_timestamp(),
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `temp_social_streams`;
CREATE TABLE `temp_social_streams`
(
    `id`                 int(11) NOT NULL AUTO_INCREMENT,
    `broadcaster_id`     int(11) NOT NULL,
    `youtube_key`        varchar(255)          DEFAULT NULL,
    `youtube_status`     varchar(255)          DEFAULT NULL,
    `facebook_key`       varchar(255)          DEFAULT NULL,
    `facebook_status`    varchar(255)          DEFAULT NULL,
    `twitch_key`         varchar(255)          DEFAULT NULL,
    `twitch_status`      varchar(255)          DEFAULT NULL,
    `twitch_server`      varchar(255)          DEFAULT NULL,
    `periscope_key`      varchar(255)          DEFAULT NULL,
    `periscope_status`   varchar(255)          DEFAULT NULL,
    `dailymotion_key`    varchar(255)          DEFAULT NULL,
    `dailymotion_status` varchar(255)          DEFAULT NULL,
    `custom_key`         varchar(255)          DEFAULT NULL,
    `custom_status`      varchar(255)          DEFAULT NULL,
    `custom_url`         varchar(255)          DEFAULT NULL,
    `telegram_key`       varchar(255)          DEFAULT NULL,
    `telegram_status`    varchar(255)          DEFAULT NULL,
    `telegram_url`       varchar(255) NOT NULL DEFAULT 'rtmps://dc4-1.rtmp.t.me/s/',
    `stream_type`        varchar(255)          DEFAULT NULL,
    `created_at`         timestamp    NOT NULL DEFAULT current_timestamp(),
    `updated_at`         timestamp    NOT NULL DEFAULT current_timestamp(),
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `temp_videos`;
CREATE TABLE `temp_videos`
(
    `id`             int(11) NOT NULL AUTO_INCREMENT,
    `playlist_id`    int(11) NOT NULL,
    `broadcaster_id` int(11) NOT NULL,
    `name`           varchar(3000) NOT NULL,
    `file`           varchar(3000) NOT NULL,
    `image`          longtext,
    `position`       int(11) NOT NULL DEFAULT 0,
    `duration`       varchar(255)           DEFAULT NULL,
    `created_at`     timestamp     NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp (),
    `updated_at`     timestamp     NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp (),
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


-- 2020-10-29 23:00:39
