var app = new Vue({
		el: '#app',
		data: {
				playing: false,
				volume: null,
				paused: false,
				muted: false,
				isHls: false,
				src: null,
				time: 0,
				player: null,
				url: []
		},
		created: function () {
				this.init();
		},
		methods: {
				init: function () {
						this.player = new rPlayer();
						this.log();
						var self = this;
						this.player.onTimeUpdate = function () {
								self.log();
						};


						// get link by axios
						var currentUrl = window.location.pathname;
						axios.get('../../../api'+currentUrl)
						.then((response) => {
							this.url = response.data.data.link;
						})
						// Catch and display errors
						.catch((error) => {
							console.log(error);
						});

				},
				up: function () {
						this.player.volume += 1;

						this.log();
				},
				down: function () {
						this.player.volume -= 1;

						this.log();
				},
				mute: function () {
						this.player.mute();

						this.log();
				},
				pause: function () {
						this.player.pause();
						this.log();
				},
				play: function () {
						this.player.play(this.url);

						this.log();
				},
				stop: function () {
						this.player.stop();

						this.log();
				},
				log: function () {
						this.playing = this.player.playing;
						this.volume = this.player.volume * 10;
						this.paused = this.player.paused;
						this.muted = this.player.muted;
						this.src = this.player.src;
						this.isHls = this.player.isHls;
						this.time = Math.floor( this.player.currentTime / 60)+" : "+  parseInt(this.player.currentTime % 60);
				}
		}
});
