<?php
session_start(); // Inicia a sessão

// Caminho para o arquivo JSON e diretório de upload
$jsonFile = './img/api.json'; // Caminho do arquivo JSON
$uploadDir = './img/'; // Diretório de uploads
$backgroundFileName = "bg.jpg"; // Nome do arquivo de background

// Função para carregar os dados do JSON
function carregarDadosJson() {
    global $jsonFile;
    $jsonData = file_get_contents($jsonFile);
    return json_decode($jsonData, true);
}

// Função para atualizar o arquivo JSON com o nome do background
function atualizarJsonBackground($novoNomeBg) {
    global $jsonFile;
    $jsonData = file_get_contents($jsonFile);
    $data = json_decode($jsonData, true);

    // Atualizando o nome do background no JSON
    if (isset($data['data'][0])) {
        $data['data'][0]['background'] = $novoNomeBg;

        // Salvando as alterações no arquivo JSON
        file_put_contents($jsonFile, json_encode($data, JSON_PRETTY_PRINT));
        return true;
    }
    return false;
}

// Carregar os dados do JSON
$dados = carregarDadosJson();

// Verifica se o formulário de upload do background foi enviado
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_FILES['background']) && $_FILES['background']['error'] === UPLOAD_ERR_OK) {

    // Nome do arquivo a ser renomeado para bg.jpg
    $novoNomeBg = $backgroundFileName;

    // Verifica se o arquivo é uma imagem válida (opcional)
    $fileTmpPath = $_FILES['background']['tmp_name'];
    $fileName = $_FILES['background']['name'];
    $fileSize = $_FILES['background']['size'];
    $fileType = $_FILES['background']['type'];

    // Verifica se o arquivo enviado é uma imagem
    $imageInfo = getimagesize($fileTmpPath);
    if ($imageInfo === false) {
        echo "<div class='container bg-msg error'>O arquivo enviado para background não é uma imagem válida.</div>";
        exit;
    }

    // Se for PNG ou JPEG, podemos usar o arquivo diretamente, caso contrário, converte para JPG
    $image = null;
    $ext = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));

    if ($ext == 'jpg' || $ext == 'jpeg') {
        $image = imagecreatefromjpeg($fileTmpPath); // Cria imagem de um arquivo JPEG
    } elseif ($ext == 'png') {
        $image = imagecreatefrompng($fileTmpPath); // Cria imagem de um arquivo PNG
        // Remover o canal alfa para salvar como JPG
        $bg = imagecreatetruecolor(imagesx($image), imagesy($image));
        imagefill($bg, 0, 0, imagecolorallocate($bg, 255, 255, 255));
        imagealphablending($bg, true);
        imagecopy($bg, $image, 0, 0, 0, 0, imagesx($image), imagesy($image));
        imagedestroy($image);
        $image = $bg;
    } elseif ($ext == 'gif') {
        $image = imagecreatefromgif($fileTmpPath); // Cria imagem de um arquivo GIF
        // Remover o canal alfa para salvar como JPG
        $bg = imagecreatetruecolor(imagesx($image), imagesy($image));
        imagefill($bg, 0, 0, imagecolorallocate($bg, 255, 255, 255));
        imagealphablending($bg, true);
        imagecopy($bg, $image, 0, 0, 0, 0, imagesx($image), imagesy($image));
        imagedestroy($image);
        $image = $bg;
    } else {
        echo "<div class='container bg-msg error'>Formato de imagem não suportado para background. Envie JPG, JPEG, PNG ou GIF. O arquivo será salvo como JPG.</div>";
        // Se for outro formato, tenta converter para JPG
        $image = imagecreatefromstring(file_get_contents($fileTmpPath));
        if ($image === false) {
            exit;
        }
        $bg = imagecreatetruecolor(imagesx($image), imagesy($image));
        imagefill($bg, 0, 0, imagecolorallocate($bg, 255, 255, 255));
        imagealphablending($bg, true);
        imagecopy($bg, $image, 0, 0, 0, 0, imagesx($image), imagesy($image));
        imagedestroy($image);
        $image = $bg;
    }

    // Salva a imagem como JPG no diretório de uploads
    if (imagejpeg($image, $uploadDir . $novoNomeBg, 80)) { // Qualidade 80
        // Atualiza o JSON
        if (atualizarJsonBackground($novoNomeBg)) {
            $bgMensagem = "Background enviado e salvo como: " . $novoNomeBg;
        } else {
            echo "<div class='container bg-msg error'>Erro ao atualizar o arquivo JSON com o nome do background.</div>";
        }
        imagedestroy($image); // Libera a memória
    } else {
        echo "<div class='container bg-msg error'>Erro ao mover o arquivo de background para o diretório.</div>";
    }
}

// Função para redimensionar a imagem de background
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['redimensionar_bg'])) {
    $largura_bg = filter_input(INPUT_POST, 'largura_bg', FILTER_VALIDATE_INT);
    $altura_bg = filter_input(INPUT_POST, 'altura_bg', FILTER_VALIDATE_INT);

    if ($largura_bg && $altura_bg && $largura_bg > 0 && $altura_bg > 0) {
        $imagePathBg = $uploadDir . $backgroundFileName;
        if (file_exists($imagePathBg)) {
            $image_bg = imagecreatefromjpeg($imagePathBg);
            if (!$image_bg) {
                $image_bg = imagecreatefrompng($imagePathBg);
            }
            if (!$image_bg) {
                $image_bg = imagecreatefromgif($imagePathBg);
            }

            if ($image_bg) {
                $novaImagemBg = imagescale($image_bg, $largura_bg, $altura_bg);

                // Salvar a imagem redimensionada como JPG (mantendo a consistência do nome)
                imagejpeg($novaImagemBg, $imagePathBg, 80);

                // Atualiza o JSON com a nova imagem
                atualizarJsonBackground($backgroundFileName);
                imagedestroy($image_bg);
                imagedestroy($novaImagemBg);

                $bgMensagem = "Background redimensionado para: $largura_bg x $altura_bg";
            } else {
                echo "<div class='container bg-msg error'>Erro ao carregar a imagem de background para redimensionamento.</div>";
            }
        } else {
            echo "<div class='container bg-msg error'>Imagem de background não encontrada para redimensionamento.</div>";
        }
    } else {
        echo "<div class='container bg-msg error'>Por favor, insira dimensões válidas para redimensionamento do background.</div>";
    }
}

// Obtém as dimensões da imagem de background atual
$imagePathBg = $uploadDir . $backgroundFileName;
$currentWidthBg = null;
$currentHeightBg = null;
if (file_exists($imagePathBg)) {
    $imageSizeBg = @getimagesize($imagePathBg); // Use @ para evitar erros se o arquivo não for imagem
    if ($imageSizeBg) {
        $currentWidthBg = $imageSizeBg[0]; // Largura
        $currentHeightBg = $imageSizeBg[1]; // Altura
    }
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Background Upload and Resizing</title>

    <script src="https://cdn.jsdelivr.net/particles.js/2.0.0/particles.min.js"></script>

    <style>
        /* Estilizando a página */
        body, html {
            height: 100%;
            margin: 0;
            font-family: Arial, sans-serif;
            display: flex;
            flex-direction: column; /* Flexbox para o layout */
            justify-content: flex-start;
            position: relative;
            background-color: #f4f4f4; /* Cor de fundo padrão da página */
        }

        /* Particles background */
        #particles-js {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: 0; /* Partículas ficam abaixo do conteúdo */
        }

        /* Container principal que segura os formulários e conteúdo */
        .container {
            position: relative;
            z-index: 2; /* Garantir que o conteúdo do formulário fique acima do fundo */
            text-align: center;
            padding: 20px;
            background: rgba(50, 50, 50, 0.7); /* Cinza escuro translúcido */
            color: white; /* Texto branco */
            border-radius: 8px;
            box-shadow: 0 10px 20px rgba(0, 0, 0, 0.3);
            max-width: 600px;
            width: 100%;
            margin: 20px auto; /* Centraliza o conteúdo com margem superior */
        }

        .container h2 {
            margin-bottom: 20px;
        }

        .container input[type="file"],
        .container input[type="text"],
        .container input[type="submit"] {
            padding: 10px;
            margin-bottom: 20px;
            background-color: #444; /* Cor de fundo do input */
            border: none;
            border-radius: 5px;
            color: white;
            box-sizing: border-box; /* Para que padding não aumente o tamanho */
            width: 100%; /* Inputs ocupam a largura total do container */
        }

        .container input[type="submit"]:hover {
            background-color: #17A673;
            cursor: pointer;
        }

        .container img {
            margin-top: 20px;
            max-width: 150px; /* Diminui o tamanho máximo da imagem */
            height: auto;
            border-radius: 5px;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.2);
            margin-bottom: 20px; /* Adiciona um pouco de espaço abaixo da imagem */
        }

        /* Rodapé */
        footer {
            width: 100%;
            padding: 10px;
            background-color: #000;
            color: white;
            text-align: center;
            margin-top: auto; /* Garantir que o rodapé fique ao final */
            position: relative;
            z-index: 2; /* Rodapé acima do fundo */
        }

        .bg-msg {
            margin-top: 20px;
            color: #1cc88a;
            font-weight: bold;
        }

        .bg-msg.error {
            color: #e74a3b;
        }

        /* Estilo para o form de redimensionamento */
        .redimensionar-form {
            margin-top: 20px;
            padding: 15px;
            border: 1px solid #555;
            border-radius: 5px;
            text-align: left;
        }

        .redimensionar-form h3 {
            margin-top: 0;
            margin-bottom: 10px;
            text-align: center;
        }

        .redimensionar-form label {
            display: block;
            margin-bottom: 5px;
            font-weight: bold;
        }

        .redimensionar-form input[type="text"] {
            width: calc(100% - 22px); /* Ajuste para o padding */
            box-sizing: border-box;
        }

        .redimensionar-form input[type="submit"] {
            margin-top: 10px;
            width: 100%;
        }
    </style>
</head>
<body>

    <div id="particles-js"></div> <?php include 'includes/header.php'; ?>

    <div class="container">
        <h2>Sending Background</h2>
        <form action="upload_bg.php" method="POST" enctype="multipart/form-data">
            <label for="background">Select a background image (JPG, JPEG, PNG ou GIF):</label>
            <input type="file" name="background" id="background" accept="image/jpeg, image/png, image/gif" required><br><br>
            <input type="submit" value="Enviar Background">
        </form>

        <h3>Active Background:</h3>
        <?php
        // Exibe o background atual com espaçamento adequado e com o cache limpo
        if (isset($dados['data'][0]['background']) && file_exists('./img/' . $dados['data'][0]['background'])) {
            $bgUrl = './img/' . $dados['data'][0]['background'] . '?' . time(); // Parâmetro para evitar cache
            echo "<img src='$bgUrl' alt='Background'><br>";
        } else {
            echo "<p>Nenhum background definido.</p>";
        }
        ?>

        <?php if ($currentWidthBg && $currentHeightBg): ?>
            <p><strong>Current background dimensions:</strong> <?php echo $currentWidthBg . 'x' . $currentHeightBg; ?> px</p>
        <?php else: ?>
            <p><strong>Current background dimensions:</strong> Unknown</p>
        <?php endif; ?>

        <?php if (isset($bgMensagem)) { echo "<p class='bg-msg'>$bgMensagem</p>"; } ?>

        <div class="redimensionar-form">
            <h3>Resize Background:</h3>
            <form action="upload_bg.php" method="POST">
                <label for="largura_bg">Width:</label>
                <input type="text" name="largura_bg" id="largura_bg" value="<?php echo $currentWidthBg ?? ''; ?>" required>
                <label for="altura_bg">Height:</label>
                <input type="text" name="altura_bg" id="altura_bg" value="<?php echo $currentHeightBg ?? ''; ?>" required>
                <input type="submit" name="redimensionar_bg" value="Resize Background">
            </form>
        </div>

    </div>

    <script>
        // Inicializa o efeito de partículas
        particlesJS('particles-js', {
            "particles": {
                "number": {
                    "value": 80,
                    "density": {
                        "enable": true,
                        "value_area": 800
                    }
                },
                "color": {
                    "value": "#1cc88a"
                },
                "shape": {
                    "type": "circle",
                    "stroke": {
                        "width": 0,
                        "color": "#000000"
                    }
                },
                "opacity": {
                    "value": 0.5,
                    "random": true,
                    "anim": {
                        "enable": true,
                        "speed": 1,
                        "opacity_min": 0.1
                    }
                },
                "size": {
                    "value": 3,
                    "random": true,
                    "anim": {
                        "enable": true,
                        "speed": 40,
                        "size_min": 0.1
                    }
                },
                "line_linked": {
                    "enable": true,
                    "distance": 150,
                    "color": "#1cc88a",
                    "opacity": 0.4,
                    "width": 1
                },
                "move": {
                    "enable": true,
                    "speed": 6,
                    "direction": "none",
                    "random": false,
                    "straight": false,
                    "out_mode": "out",
                    "attract": {
                        "enable": false,
                        "rotateX": 600,
                        "rotateY": 600
                    }
                }
            },
            "interactivity": {
                "detect_on": "canvas",
                "events": {
                    "onhover": {
                        "enable":true,
                        "mode":"repulse"
                    },
                    "onclick": {
                        "enable": true,
                        "mode": "push"
                    }
                }
            },
            "retina_detect": true
        });
    </script>

    <footer>
        <p>&copy; <?php echo date("Y"); ?> @2025 All rights reserved.</p>
    </footer>

</body>
</html>