<?php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

include 'includes/header.php'; 

// Salvar a URL enviada
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $novaUrl = trim($_POST['url']);
    if (filter_var($novaUrl, FILTER_VALIDATE_URL)) {
        file_put_contents('jogos_url.txt', $novaUrl);
        $mensagem = "✅ URL salva com sucesso!";
    } else {
        $mensagem = "❌ URL inválida!";
    }
}

$urlAtual = file_exists('jogos_url.txt') ? file_get_contents('jogos_url.txt') : '';
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Configure Sport Guide URL</title>
    <style>
        html, body {
            margin: 0;
            padding: 0;
            height: 100%;
            font-family: Arial, sans-serif;
            background: #f0f0f0;
        }

        .container {
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            height: 100%;
            text-align: center;
            padding: 20px;
        }

        .form-box {
            background: #fff;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 0 20px rgba(0,0,0,0.1);
            max-width: 600px;
            width: 100%;
        }

        h2 {
            margin-bottom: 20px;
            color: #333;
        }

        input[type="text"] {
            width: 100%;
            padding: 15px;
            font-size: 16px;
            border: 1px solid #ccc;
            border-radius: 6px;
            box-sizing: border-box;
        }

        button {
            margin-top: 20px;
            padding: 14px 28px;
            font-size: 16px;
            border: none;
            background-color: #28a745;
            color: white;
            border-radius: 6px;
            cursor: pointer;
        }

        .mensagem {
            margin-top: 15px;
            font-weight: bold;
            color: #007bff;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="form-box">
            <h2>🔗 Configure Sports Guide URL</h2>
            <form method="POST">
                <input type="text" name="url" placeholder="https://sportsguide/page.html" value="<?= htmlspecialchars($urlAtual) ?>" required>
                <button type="submit">Save URL</button>
            </form>
            <?php if (!empty($mensagem)): ?>
                <div class="mensagem"><?= $mensagem ?></div>
            <?php endif; ?>
        </div>
    </div>
</body>
</html>
