<?php
session_start();
include 'includes/header.php';

$arquivo_status_botao = './api/btnteste_status.json';
$arquivo_url_bot_txt = './api/bot_url.txt';
$dbFileTestes = __DIR__ . '/api/testes.db';

$mensagem_sucesso_php = '';
$mensagem_erro_php = '';

function inicializar_arquivo($filepath, $default_content) {
    if (!file_exists(dirname($filepath))) {
        mkdir(dirname($filepath), 0775, true);
    }
    if (!file_exists($filepath)) {
        file_put_contents($filepath, $default_content);
    }
}

inicializar_arquivo($arquivo_status_botao, json_encode(['status' => '0'], JSON_PRETTY_PRINT));
inicializar_arquivo($arquivo_url_bot_txt, '');

$dbTestes = new SQLite3($dbFileTestes);
$dbTestes->exec("CREATE TABLE IF NOT EXISTS testes (
    id TEXT PRIMARY KEY,
    username TEXT NOT NULL,
    password TEXT NOT NULL,
    dns TEXT NOT NULL,
    criado_em DATETIME DEFAULT CURRENT_TIMESTAMP
);");

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['action']) && $_POST['action'] === 'save_button_status') {
        $new_status_val = isset($_POST['status']) ? '1' : '0';
        $dados_atuais_botao = [];
        if (file_exists($arquivo_status_botao)) {
            $dados_atuais_botao = json_decode(file_get_contents($arquivo_status_botao), true) ?? [];
        }
        $dados_atuais_botao['status'] = $new_status_val;
        if (file_put_contents($arquivo_status_botao, json_encode($dados_atuais_botao, JSON_PRETTY_PRINT)) !== false) {
            $_SESSION['mensagem_sucesso'] = "Status do botão salvo com sucesso!";
        } else {
            $_SESSION['mensagem_erro'] = "Erro ao salvar status do botão.";
        }
    } elseif (isset($_POST['action']) && $_POST['action'] === 'save_bot_url') {
        $nova_url = $_POST['url_bot'] ?? '';
        if (!empty($nova_url) && !filter_var($nova_url, FILTER_VALIDATE_URL)) {
            $_SESSION['mensagem_erro'] = "URL inválida!";
        } else {
            if (file_put_contents($arquivo_url_bot_txt, $nova_url) !== false) {
                $_SESSION['mensagem_sucesso'] = "URL do bot salva com sucesso!";
            } else {
                $_SESSION['mensagem_erro'] = "Erro ao salvar a URL.";
            }
        }
    } elseif (isset($_POST['action']) && $_POST['action'] === 'delete_test') {
        $id_to_delete = $_POST['test_id'] ?? '';
        if (!empty($id_to_delete)) {
            $stmt = $dbTestes->prepare("DELETE FROM testes WHERE id = :id");
            $stmt->bindValue(':id', $id_to_delete, SQLITE3_TEXT);
            if ($stmt->execute()) {
                $_SESSION['mensagem_sucesso'] = "Teste com ID '{$id_to_delete}' deletado.";
            } else {
                $_SESSION['mensagem_erro'] = "Erro ao deletar teste.";
            }
        }
    }
}

$status_botao_inicial = '0';
$url_teste_auto_inicial = '';
if (file_exists($arquivo_status_botao)) {
    $data = json_decode(file_get_contents($arquivo_status_botao), true);
    $status_botao_inicial = $data['status'] ?? '0';
}
if (file_exists($arquivo_url_bot_txt)) {
    $url_teste_auto_inicial = trim(file_get_contents($arquivo_url_bot_txt));
}

$termo_busca = $_GET['busca'] ?? '';
$testes = [];
$query = "SELECT id, username, password, dns, criado_em FROM testes";
$params = [];

if (!empty($termo_busca)) {
    $query .= " WHERE id LIKE :termo OR username LIKE :termo OR dns LIKE :termo";
    $params[':termo'] = '%' . $termo_busca . '%';
}
$query .= " ORDER BY criado_em DESC";

$stmt = $dbTestes->prepare($query);
foreach ($params as $key => $val) {
    $stmt->bindValue($key, $val, SQLITE3_TEXT);
}
$result = $stmt->execute();
while ($row = $result->fetchArray(SQLITE3_ASSOC)) {
    $testes[] = $row;
}
$dbTestes->close();

if (isset($_SESSION['mensagem_sucesso'])) {
    $mensagem_sucesso_php = $_SESSION['mensagem_sucesso'];
    unset($_SESSION['mensagem_sucesso']);
}
if (isset($_SESSION['mensagem_erro'])) {
    $mensagem_erro_php = $_SESSION['mensagem_erro'];
    unset($_SESSION['mensagem_erro']);
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Painel de Teste Automático</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; font-family: 'Segoe UI', sans-serif; }
        body {
            background: #121212;
            color: #fff;
            padding: 20px;
            min-height: 100vh;
        }
        .container {
            max-width: 1000px;
            margin: auto;
        }
        h1 {
            text-align: center;
            margin-bottom: 20px;
            font-size: 2em;
        }
        .card {
            background: #1e1e1e;
            padding: 20px;
            border-radius: 10px;
            margin-bottom: 20px;
            box-shadow: 0 0 8px rgba(0,0,0,0.6);
        }
        label, input, button {
            display: block;
            width: 100%;
            margin-bottom: 10px;
        }
        input {
            padding: 10px;
            border: 1px solid #333;
            background: #2a2a2a;
            color: #fff;
            border-radius: 5px;
        }
        button {
            background: #00c853;
            border: none;
            color: white;
            padding: 10px;
            border-radius: 5px;
            cursor: pointer;
            font-weight: bold;
            transition: 0.2s ease;
        }
        button:hover {
            background: #00a148;
        }
        .message {
            padding: 10px;
            margin-bottom: 20px;
            border-radius: 5px;
            font-weight: bold;
        }
        .success { background: #2e7d32; }
        .error { background: #c62828; }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }
        table, th, td {
            border: 1px solid #333;
        }
        th, td {
            padding: 10px;
            text-align: left;
        }
        th {
            background: #2c2c2c;
        }
        tr:nth-child(even) {
            background: #1b1b1b;
        }
        @media(max-width: 768px) {
            table, thead, tbody, th, td, tr {
                display: block;
            }
            td {
                border: none;
                border-bottom: 1px solid #333;
                position: relative;
                padding-left: 50%;
            }
            td:before {
                position: absolute;
                top: 10px;
                left: 10px;
                font-weight: bold;
            }
        }
    </style>
</head>
<body>
<div class="container">
    <h1>Painel de Teste Automático</h1>

    <?php if ($mensagem_sucesso_php): ?>
        <div class="message success"><?= $mensagem_sucesso_php ?></div>
    <?php endif; ?>
    <?php if ($mensagem_erro_php): ?>
        <div class="message error"><?= $mensagem_erro_php ?></div>
    <?php endif; ?>

    <div class="card">
        <form method="POST">
            <input type="hidden" name="action" value="save_button_status">
            <label>Status do botão "Teste Grátis":</label>
            <input type="checkbox" name="status" value="1" <?= $status_botao_inicial === '1' ? 'checked' : '' ?>> Ativado
            <button type="submit">Salvar Status</button>
        </form>
    </div>

    <div class="card">
        <form method="POST">
            <input type="hidden" name="action" value="save_bot_url">
            <label>URL do Bot:</label>
            <input type="text" name="url_bot" value="<?= htmlspecialchars($url_teste_auto_inicial) ?>" placeholder="https://seudominio.com/bot/teste">
            <button type="submit">Salvar URL</button>
        </form>
    </div>

    <div class="card">
        <form method="GET">
            <input type="text" name="busca" value="<?= htmlspecialchars($termo_busca) ?>" placeholder="Buscar por ID, username ou DNS">
            <button type="submit">Buscar</button>
        </form>

        <?php if (!empty($testes)): ?>
            <table>
                <thead>
                <tr>
                    <th>ID</th><th>Usuário</th><th>Senha</th><th>DNS</th><th>Criado em</th><th>Ação</th>
                </tr>
                </thead>
                <tbody>
                <?php foreach ($testes as $teste): ?>
                    <tr>
                        <td><?= htmlspecialchars($teste['id']) ?></td>
                        <td><?= htmlspecialchars($teste['username']) ?></td>
                        <td><?= htmlspecialchars($teste['password']) ?></td>
                        <td><?= htmlspecialchars($teste['dns']) ?></td>
                        <td><?= htmlspecialchars($teste['criado_em']) ?></td>
                        <td>
                            <form method="POST" onsubmit="return confirm('Deseja deletar este teste?')">
                                <input type="hidden" name="action" value="delete_test">
                                <input type="hidden" name="test_id" value="<?= htmlspecialchars($teste['id']) ?>">
                                <button style="background:#c62828;">Deletar</button>
                            </form>
                        </td>
                    </tr>
                <?php endforeach ?>
                </tbody>
            </table>
        <?php else: ?>
            <p style="margin-top:10px;">Nenhum teste encontrado.</p>
        <?php endif ?>
    </div>
</div>
</body>
</html>
