<?php
session_start();

// Defina o diretório onde os APKs serão salvos (certifique-se de que esta pasta exista e tenha permissões de escrita)
$uploadDir = __DIR__ . '/ota/';

// Defina o caminho para o arquivo versao_app.json DENTRO da pasta ota
$versaoAppJsonPath = __DIR__ . '/ota/versao_app.json';

// Função para gerar um nome de arquivo seguro
function sanitizeFilename($filename) {
    $filename = preg_replace('/[^a-zA-Z0-9._-]/', '', $filename);
    return $filename;
}

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['versao']) && isset($_FILES['apk_file'])) {
        $versao = trim($_POST['versao']);
        $apkFile = $_FILES['apk_file'];

        // Validações básicas
        if (empty($versao)) {
            echo json_encode(['status' => 'erro', 'mensagem' => 'Version cannot be empty.']);
            exit;
        }

        if ($apkFile['error'] !== UPLOAD_ERR_OK) {
            echo json_encode(['status' => 'erro', 'mensagem' => 'Error uploading APK file. Code: ' . $apkFile['error']]);
            exit;
        }

        if ($apkFile['type'] !== 'application/vnd.android.package-archive') {
            echo json_encode(['status' => 'erro', 'mensagem' => 'The uploaded file is not an APK.']);
            exit;
        }

        if ($apkFile['size'] > 50 * 1024 * 1024) { // Limite de 50MB (ajuste conforme necessário)
            echo json_encode(['status' => 'erro', 'mensagem' => 'The APK file is too large.']);
            exit;
        }

        // Gera um nome de arquivo seguro com a versão
        $nomeBase = pathinfo($apkFile['name'], PATHINFO_FILENAME);
        $nomeSeguro = sanitizeFilename($nomeBase) . '_' . sanitizeFilename($versao) . '.apk';
        $caminhoCompleto = $uploadDir . $nomeSeguro;

        // Move o arquivo para o diretório de upload
        if (move_uploaded_file($apkFile['tmp_name'], $caminhoCompleto)) {
            // Atualiza o arquivo versao_app.json
            $data = [
                'versao_recente' => $versao,
                'url_apk' => 'https://' . $_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF']) . '/' . basename($uploadDir) . '/' . $nomeSeguro
            ];

            if (file_put_contents($versaoAppJsonPath, json_encode($data, JSON_PRETTY_PRINT))) {
                echo json_encode(['status' => 'success', 'mensagem' => 'New app version submitted and information updated.']);
            } else {
                echo json_encode(['status' => 'erro', 'mensagem' => 'Error updating version file.']);
                // Opcional: Apagar o APK enviado em caso de falha ao atualizar o JSON
                unlink($caminhoCompleto);
            }
        } else {
            echo json_encode(['status' => 'erro', 'mensagem' => 'Error saving APK file to server.']);
        }

    } else {
        echo json_encode(['status' => 'erro', 'mensagem' => 'APK file or version data not received.']);
    }
} else {
    echo json_encode(['status' => 'erro', 'mensagem' => 'Invalid request method. Use POST..']);
}
?>