<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
date_default_timezone_set('America/Sao_Paulo');
header('Content-Type: text/plain; charset=utf-8');

$id = $_GET['id'] ?? '';
if (!$id) {
    http_response_code(400);
    echo "erro|ID não especificado.";
    exit;
}

$id = strtoupper(preg_replace('/[^A-Fa-f0-9]/', '', $id));

// === INICIALIZA DB DE TESTES ===
$dbFile = __DIR__ . '/testes.db';
try {
    $db = new SQLite3($dbFile);
    $db->exec("CREATE TABLE IF NOT EXISTS testes (
        id TEXT PRIMARY KEY,
        username TEXT NOT NULL,
        password TEXT NOT NULL,
        dns TEXT NOT NULL,
        criado_em DATETIME DEFAULT CURRENT_TIMESTAMP,
        expires_at INTEGER
    )");
} catch (Exception $e) {
    http_response_code(500);
    echo "erro|Erro ao acessar DB de testes: " . $e->getMessage();
    exit;
}

// === BLOQUEIO SE JÁ EXISTE ===
$stmt = $db->prepare("SELECT username, password, dns, expires_at FROM testes WHERE id = :id");
$stmt->bindValue(':id', $id, SQLITE3_TEXT);
$res = $stmt->execute()->fetchArray(SQLITE3_ASSOC);

if ($res && $res['username'] && $res['password'] && $res['dns'] && isset($res['expires_at'])) {
    // SE JÁ EXISTE, NÃO GERA NOVO TESTE
    echo "erro|Já existe teste gerado para este ID.";
    $db->close();
    exit;
}

// === LER URL DO BOT ===
$arquivo_url_bot_txt = __DIR__ . '/bot_url.txt';
$urlBot = '';
if (file_exists($arquivo_url_bot_txt)) {
    $urlBot = trim(file_get_contents($arquivo_url_bot_txt));
}
if (empty($urlBot)) {
    http_response_code(500);
    echo "erro|URL da API do bot não configurada: $arquivo_url_bot_txt";
    $db->close();
    exit;
}

// === ENVIA REQUISIÇÃO AO BOT ===
$mensagemJson = json_encode([
    "receiveMessageAppId" => "com.whatsapp",
    "receiveMessagePattern" => ["*"],
    "senderName" => "API DE TESTE",
    "groupName" => "",
    "senderMesage" => "teste iptv",
    "senderMessage" => "teste iptv",
    "messageDateTime" => time(),
    "isMessageFromGroup" => false
]);

$ch = curl_init($urlBot);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $mensagemJson);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json',
    'Content-Length: ' . strlen($mensagemJson)
]);
curl_setopt($ch, CURLOPT_TIMEOUT, 25);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$curlError = curl_error($ch);
curl_close($ch);

if ($response === false) {
    http_response_code(500);
    echo "erro|Falha na requisição ao bot: $curlError";
    $db->close();
    exit;
}

$jsonRetorno = json_decode($response, true);
if (json_last_error() !== JSON_ERROR_NONE) {
    http_response_code(500);
    echo "erro|Resposta inválida do bot: " . json_last_error_msg();
    $db->close();
    exit;
}

if (
    isset($jsonRetorno['username']) &&
    isset($jsonRetorno['password']) &&
    isset($jsonRetorno['dns']) &&
    isset($jsonRetorno['expiresAt'])
) {
    $username = $jsonRetorno['username'];
    $password = $jsonRetorno['password'];
    $dns = rtrim($jsonRetorno['dns'], '/');

    if (!preg_match("~^(?:f|ht)tps?://~i", $dns)) {
        $dns = "http://" . $dns;
    }

    try {
        $dtExpires = new DateTime($jsonRetorno['expiresAt']);
        $exp_date_timestamp = $dtExpires->getTimestamp();
    } catch (Exception $e) {
        $exp_date_timestamp = (new DateTime('+360 days'))->getTimestamp();
    }

    // === SALVAR NO DB DE TESTES ===
    $stmt = $db->prepare("INSERT OR REPLACE INTO testes (id, username, password, dns, expires_at, criado_em)
                          VALUES (:id, :user, :pass, :dns, :expires_at, CURRENT_TIMESTAMP)");
    $stmt->bindValue(':id', $id, SQLITE3_TEXT);
    $stmt->bindValue(':user', $username, SQLITE3_TEXT);
    $stmt->bindValue(':pass', $password, SQLITE3_TEXT);
    $stmt->bindValue(':dns', $dns, SQLITE3_TEXT);
    $stmt->bindValue(':expires_at', $exp_date_timestamp, SQLITE3_INTEGER);
    $stmt->execute();

    // === SALVAR NO DB PRINCIPAL ===
    salvarNaTabelaUsuarios($username, $password, $dns, $id, $exp_date_timestamp);

    // === RETORNO PARA O APP ===
    enviarRespostaComExpDate($dns, $username, $password, $exp_date_timestamp);
    $db->close();
    exit;
} else {
    http_response_code(500);
    echo "erro|Resposta incompleta da API do bot: $response";
    $db->close();
    exit;
}

// === SALVAR USUÁRIO EM BOXBRDB ===
function salvarNaTabelaUsuarios($username, $password, $dns, $device_id, $exp_date_timestamp) {
    $validade_str = date('Y-m-d H:i:s', $exp_date_timestamp);
    $dbUsuarios = new SQLite3(__DIR__ . '/boxbrdb.db');
    $dbUsuarios->exec("CREATE TABLE IF NOT EXISTS usuarios (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        username TEXT NOT NULL,
        password TEXT NOT NULL,
        dns TEXT NOT NULL,
        validade TEXT NOT NULL,
        device_id TEXT UNIQUE
    )");

    $stmtCheck = $dbUsuarios->prepare("SELECT COUNT(*) FROM usuarios WHERE device_id = :device_id");
    $stmtCheck->bindValue(':device_id', $device_id, SQLITE3_TEXT);
    $count = $stmtCheck->execute()->fetchArray(SQLITE3_NUM)[0];

    if ($count > 0) {
        $stmtUpdate = $dbUsuarios->prepare("UPDATE usuarios SET username = :username, password = :password, dns = :dns, validade = :validade WHERE device_id = :device_id");
        $stmtUpdate->bindValue(':username', $username, SQLITE3_TEXT);
        $stmtUpdate->bindValue(':password', $password, SQLITE3_TEXT);
        $stmtUpdate->bindValue(':dns', $dns, SQLITE3_TEXT);
        $stmtUpdate->bindValue(':validade', $validade_str, SQLITE3_TEXT);
        $stmtUpdate->bindValue(':device_id', $device_id, SQLITE3_TEXT);
        $stmtUpdate->execute();
    } else {
        $stmtInsert = $dbUsuarios->prepare("INSERT INTO usuarios (username, password, dns, validade, device_id)
                                            VALUES (:username, :password, :dns, :validade, :device_id)");
        $stmtInsert->bindValue(':username', $username, SQLITE3_TEXT);
        $stmtInsert->bindValue(':password', $password, SQLITE3_TEXT);
        $stmtInsert->bindValue(':dns', $dns, SQLITE3_TEXT);
        $stmtInsert->bindValue(':validade', $validade_str, SQLITE3_TEXT);
        $stmtInsert->bindValue(':device_id', $device_id, SQLITE3_TEXT);
        $stmtInsert->execute();
    }

    $dbUsuarios->close();
}

// === RETORNO PARA O APP ===
function enviarRespostaComExpDate($dns, $username, $password, $exp_date_timestamp) {
    header('Content-Type: text/plain; charset=utf-8');
    if (!is_numeric($exp_date_timestamp) || $exp_date_timestamp <= 0) {
        $exp_date_timestamp = (new DateTime('+360 days'))->getTimestamp();
    }
    echo "$dns|$username|$password|$exp_date_timestamp";
    exit;
}
