<?php
header('Content-Type: application/json');

// ==============================================
// CONFIGURAÇÃO
// ==============================================
define('DNS_CONFIG_FILE', 'api/dns_file.json');
define('AES_KEY', 'jb%!SZfM%AwwS7JmdM!');
define('TIMEOUT', 5);
define('MIN_FILE_SIZE', 1024); // 1KB mínimo para considerar válido
define('USER_DB_FILE', './boxbrdb.db'); // <<< ALTERAÇÃO 1 >>> Adicionamos a definição do arquivo do banco de dados

// ==============================================
// FUNÇÕES PRINCIPAIS
// ==============================================

function test_dns_connection($dns_url, $username, $password) {
    $test_url = rtrim($dns_url, '/') . "/get.php?username=" . urlencode($username) . 
                "&password=" . urlencode($password) . "&type=m3u_plus&output=mpegts";
    
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $test_url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => TIMEOUT,
        CURLOPT_SSL_VERIFYPEER => false,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_USERAGENT => 'Mozilla/5.0',
        CURLOPT_HEADER => true,
        CURLOPT_NOBODY => false
    ]);
    
    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $file_size = curl_getinfo($ch, CURLINFO_SIZE_DOWNLOAD);
    curl_close($ch);

    return ($http_code === 200 && $file_size > MIN_FILE_SIZE);
}

// <<< ALTERAÇÃO 2 >>> A função agora aceita $all_data para pegar o MAC/DeviceID
function get_valid_dns_response($username, $password, $all_data) { 
    if (!file_exists(DNS_CONFIG_FILE)) {
        return [
            'success' => false,
            'message' => 'Arquivo de DNS não encontrado',
            'error_code' => 'dns_file_not_found'
        ];
    }

    $servers = json_decode(file_get_contents(DNS_CONFIG_FILE), true);
    
    if (!is_array($servers) || empty($servers)) {
        return [
            'success' => false,
            'message' => 'Nenhuma DNS cadastrada no sistema',
            'error_code' => 'no_dns_configured'
        ];
    }

    foreach ($servers as $server_url) {
        if (!is_string($server_url)) continue;
        
        $server_url = trim($server_url);
        if (empty($server_url)) continue;

        if (test_dns_connection($server_url, $username, $password)) {

            // <<< ALTERAÇÃO 3 >>> INÍCIO DO CÓDIGO PARA SALVAR O USUÁRIO
            // Esta parte é executada APENAS se o login e senha forem válidos.
            try {
                // Pega o device_id do campo 'lan', como no seu exemplo de requisição.
                $device_id = $all_data['lan'] ?? 'nao_informado'; 

                $user_db = new SQLite3(USER_DB_FILE);
                
                // Garante que a tabela de usuários exista.
                $user_db->exec("CREATE TABLE IF NOT EXISTS usuarios (
                                id INTEGER PRIMARY KEY AUTOINCREMENT,
                                username TEXT UNIQUE,
                                password TEXT,
                                dns TEXT,
                                validade TEXT,
                                device_id TEXT
                            )");
                
                // Verifica se o usuário já existe no banco de dados local.
                $stmt = $user_db->prepare("SELECT * FROM usuarios WHERE username = :username");
                $stmt->bindValue(':username', $username, SQLITE3_TEXT);
                $result = $stmt->execute();
                $user = $result->fetchArray(SQLITE3_ASSOC);
                
                // Se o usuário NÃO for encontrado, ele é inserido.
                if (!$user) {
                    $insert_stmt = $user_db->prepare("INSERT INTO usuarios (username, password, dns, validade, device_id) VALUES (:username, :password, :dns, :validade, :device_id)");
                    $insert_stmt->bindValue(':username', $username, SQLITE3_TEXT);
                    $insert_stmt->bindValue(':password', $password, SQLITE3_TEXT);
                    $insert_stmt->bindValue(':dns', $server_url, SQLITE3_TEXT);
                    $insert_stmt->bindValue(':validade', date('Y-m-d H:i:s', strtotime('+360 days')), SQLITE3_TEXT);
                    $insert_stmt->bindValue(':device_id', $device_id, SQLITE3_TEXT);
                    $insert_stmt->execute();
                }

                $user_db->close();
            } catch (Exception $e) {
                // Se houver erro no banco de dados, o script não quebra,
                // mas você pode querer logar o erro $e->getMessage() em um arquivo de texto.
            }
            // <<< ALTERAÇÃO 3 >>> FIM DO CÓDIGO PARA SALVAR O USUÁRIO

            // Retorna a resposta de sucesso original para o app
            return [
                'success' => true,
                'server' => $server_url,
                'username' => $username,
                'password' => $password,
                'validity_days' => 365,
                'ua' => uniqid()
            ];
        }
    }

    return [
        'success' => false,
        'message' => 'Nenhuma DNS respondeu corretamente para estas credenciais',
        'error_code' => 'no_valid_dns_response'
    ];
}

function decrypt_app_data($encrypted) {
    try {
        $data = base64_decode($encrypted);
        if (strlen($data) < 16) return false;
        
        $salt = substr($data, 8, 8);
        $ct = substr($data, 16);
        
        $key_iv = '';
        $prev = '';
        while (strlen($key_iv) < 48) {
            $prev = md5($prev . AES_KEY . $salt, true);
            $key_iv .= $prev;
        }
        
        return openssl_decrypt($ct, 'aes-256-cbc', substr($key_iv, 0, 32), OPENSSL_RAW_DATA, substr($key_iv, 32, 16));
    } catch (Exception $e) {
        return false;
    }
}

// ==============================================
// PROCESSAMENTO PRINCIPAL
// ==============================================
$input = json_decode(file_get_contents('php://input'), true) ?: $_REQUEST;
$e = $input['e'] ?? null;
$data = []; // <<< ALTERAÇÃO 4 >>> Inicializamos a variável $data aqui

if ($e) {
    $decrypted = decrypt_app_data($e);
    parse_str($decrypted, $data);
    
    $credentials = !empty($data['wifi']) ? 
        explode(':', $data['wifi'], 2) : 
        [$data['username'] ?? null, $data['password'] ?? null];
} else {
    $credentials = [$input['username'] ?? null, $input['password'] ?? null];
}

// ==============================================
// RESPOSTA
// ==============================================
if (empty($credentials[0]) || empty($credentials[1])) {
    echo json_encode([
        'success' => false,
        'message' => 'Credenciais não fornecidas',
        'error_code' => 'missing_credentials'
    ]);
    exit;
}

// <<< ALTERAÇÃO 5 >>> Passamos a variável $data para a função
$response = get_valid_dns_response($credentials[0], $credentials[1], $data);
echo json_encode($response);